// DemoVisualC.cpp : Questo file contiene la funzione 'main', in cui inizia e termina l'esecuzione del programma.
//

// CAENRFIDLibrary use non-crt-secure c api so it's better to 
// shout all warnings on compiling.
#define _CRT_SECURE_NO_WARNINGS

// Including standard io for printing output and CAENRFIDLib.h for 
// CAEN RFID API calls.
#include <stdio.h>
#include "Library/CAENRFIDLib.h"

// Some utility declarations.
#define IFERROR(X) {  if ( onError(X) == TRUE ) return -1; }

static int tagCounter = 0;
char _tempId[MAX_ID_LENGTH];

BOOL onError(CAENRFIDErrorCodes ec) {
	if (ec != CAENRFID_StatusOK) {
		printf_s(" ****** ERROR (API code: %d) ****** \n", ec);
		return TRUE;
	}
	return FALSE;
};

// Function to print hex string ('hexString' should have enough space 
// allocated).
void printHex(unsigned char* data, int dataLength, char* hexString) {
	int i = 0;
	char* r = hexString;
	for (i = 0; i < dataLength; i++) {
		sprintf(r, "%02X", data[i]);
		r += 2;
	}
	return;
};

// The user-defined API CALLBACK used by internal API continuous inventory. 
CAENRFIDErrorCodes onTagReceived(CAENRFIDNotify* tags, const int numTags) {
	int i = 0;
	for (i = 0; i < numTags; i++) {
		CAENRFIDNotify tag = tags[i];
		printHex(tag.ID, tag.Length, _tempId);
		_tempId[((tag.Length) * 2)] = '\0';
		printf_s("Tag  %s \t %i\n", _tempId, tagCounter);
		tagCounter++;
	}
	_tempId[0] = '\0';

	return CAENRFID_StatusOK;
};


/*********** MAIN *************/

int main()
{
	CAENRFIDErrorCodes _ec; //error code
	CAENRFIDHandle _handle;
	//CAENRFIDPort _port = CAENRFID_TCP;
	CAENRFIDPort _port = CAENRFID_RS232;
	CAENRFIDProtocol _proto = CAENRFID_EPC_C1G2;
	CAENRFIDTag* tags;
	int numTags;
	char _tagsID[80];
	char _address[30];
	char _model[30];
	char _serial[30];
	char _source[10];
	BOOL _eosMatched = FALSE; //End Of Stream matched
	strcpy(_source, "Source_0");
	// 1) Connect to the reader.
	//_ec = CAENRFID_Init(_port, "10.106.254.115", &_handle, &_proto);
	_ec = CAENRFID_Init(_port, "COM6", &_handle, &_proto);
	// 2) Try to check if reader connection previously crashed during a continuous
	// inventory operation (in such case, some CAEN RFID readers continue to streams 
	// tags until they are rebooted or they are forced to receive an abort command.
	_ec = CAENRFID_ForceAbort(_handle, 3000, &_eosMatched);
	if (_eosMatched) {
		printf("Connection to reader has been closed abruplty during a continuous inventory\n");
	}
	else {
		printf("Reader wasn't in continuous inventory");
	}
	IFERROR(_ec);
	printf_s("Connect: %d\n", _ec);
	//3) Get reader info and print them.
	_ec = CAENRFID_GetReaderInfo(_handle, _model, _serial);
	IFERROR(_ec);
	printf_s("reader Info: %d, %s, %s\n", _ec, _model, _serial);
	//4) Set conducted power to 200 mW.
	_ec = CAENRFID_SetPower(_handle, 200);
	IFERROR(_ec);
	printf_s("Set Power to 200 mW \n");
	// 5) launch a single inventor and prints each tag found.
	/** SINGLE INVENTORY **/
	numTags = 0;
	tags = NULL;
	//Do inventory
	_ec = CAENRFID_InventoryTag(_handle, _source, &tags, &numTags);
	IFERROR(_ec);
	// Prints the ID's EPC of each tag found.
	if (numTags > 0) {
		for (int i = 0; i < numTags; i++) {
			_tagsID[0] = '\0';
			printHex(tags[i].ID, tags[i].Length, _tagsID);
			printf("Tags -> %s\n", _tagsID);
		}
		CAENRFID_FreeTagsMemory(&tags);
	}


	/** CONTINUOUS INVENTORY START **/
	// 6) launch the continuous inventory: the "onTagReceived" callback will
	//    be called upon each tags found.
	// 
	// Sets parameters for continuous inventory call and sets the callback.
	CAENRFID_EventInventoryParams params;
	// Mask filtering on ID part of the EPC : in this case we won't filter 
	// nothing and lets pass all tags.
	params.Mask = (char*)malloc(sizeof(char) * 12);
	params.MaskLength = (unsigned char)0;
	params.Position = (unsigned char)0;

	params.SourceName = _source;
	// CONTINUOUS and FRAMED are MANDATORY flags when user call CAENRFID_EventInventoryTag.
	params.flag = (short)(CONTINUOS | FRAMED); 
	params.pCallBack = (CAENRFID_INVENTORY_CALLBACK)&onTagReceived;

	// Set read cycle to 0 (infinity cycle) and launch continuous inventory.
	_ec = CAENRFID_SetReadCycle(_handle, _source, 0);
	IFERROR(_ec);
	_ec = CAENRFID_EventInventoryTag(_handle, params);
	IFERROR(_ec);
	printf("Event Inventory Tag Start: %d \n", _ec);

	/******* WAIT ON MAIN THREAD while API callback prints each tag founds. ****/
	printf("\nMain Thread sleep for 3 seconds...\n");
	Sleep(3000);
	/***************************************************************************/

	//7) Stop continuous inventory. 
	_ec = CAENRFID_InventoryAbort(_handle);
	IFERROR(_ec);
	printf("Event Inventory Abort result code: %d\n", _ec);
	/** CONTINUOUS INVENTORY END **/

	// 8) Disconnect from the reader.
	_ec = CAENRFID_End(_handle);
	IFERROR(_ec);
	printf("\nDisconnect return code: %d\n", _ec);
	Sleep(3000);
	// END
	return 0;
}
